/******************************************************************************
 *
 * Copyright (c) 2004 PalmSource, Inc. All rights reserved.
 *
 * File: SharedLib.h
 *
 * Description:
 *	  This is the header defining the contents of the shared library.
 *
 *****************************************************************************/

#ifndef SHARED_LIB_H
#define SHARED_LIB_H

#include <LibTraps.h>

/* 
 * Note that the following trap number definitions must be evaluated by 
 * the preprocessor using #defines not enum values.  
 */

#define SharedLib_FunctionA_trapNum	sysLibTrapCustom
#define SharedLib_FunctionB_trapNum	sysLibTrapCustom+1


#ifndef SHARED_LIB_TRAP
#define SHARED_LIB_TRAP(trapNum)	SYS_TRAP(trapNum)
#endif


/* Function declarations */

UInt32 SharedLib_Open(UInt16 libraryReference)
	SHARED_LIB_TRAP(sysLibTrapOpen);

UInt32 SharedLib_Close(UInt16 libraryReference, UInt16 *numAppsP)
	SHARED_LIB_TRAP(sysLibTrapClose);

UInt32  SharedLib_Sleep(UInt16 libraryReference)
	SHARED_LIB_TRAP(sysLibTrapSleep);
	
UInt32 SharedLib_Wake(UInt16 libraryReference)
	SHARED_LIB_TRAP(sysLibTrapWake);


void SharedLib_FunctionA(UInt16 libraryReference, Int32 parameter, Int32* result)
	SHARED_LIB_TRAP(SharedLib_FunctionA_trapNum);
	
void SharedLib_FunctionB(UInt16 libraryReference, Int32 parameter, Int32* result)
	SHARED_LIB_TRAP(SharedLib_FunctionB_trapNum);

#endif